set linesize 200
/************************************************************************************#
#*                                                                                   #
#* Purpose: STATA program to create permanent .DTA data set                          #
#*          harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta             #
#*          with the Harmonized TUS CPS 1992 through 2019 replicate weights 95-03    #
#*                                                                                   #
#*          The program does NOT use STATA dictionaries                              #
#*                                                                                   #
#*************************************************************************************/

/*****************************************************************************************
 Set working directory
 Input and output files are saved here
*****************************************************************************************/

cd "\\westat.com\DFS\NCIDCCPS\DCCPS - Global\Scientific Projects\TUS-CPS\Statistician\ifc\STATA work\prg\3. Harmonized data"


//*****************************************************************************************
// Create dictionary

file open dictionary  using ".\dictionary.dct", write replace
set more off

file write dictionary   /// 
"infile dictionary {" _n ///
"_column(1)"   _tab "int     SurYear " _tab "%4f   " _tab `""Survey year""' _n ///
"_column(5)"   _tab "int     SurMonth" _tab "%2f   " _tab `""Survey month""' _n ///
"_column(7)"   _tab "str22   RecordID" _tab "%22s  " _tab `""Record ID (Unique within survey month)""' _n ///
"_column(29)"  _tab "double  SmplWgt " _tab "%11.4f" _tab `""Self Response Sample Weight""' _n ///
"_column(40)"  _tab "double  RepWt001" _tab "%11.4f" _tab `""Replicate Weight #1""' _n ///
"_column(51)"  _tab "double  RepWt002" _tab "%11.4f" _tab `""Replicate Weight #2""' _n ///
"_column(62)"  _tab "double  RepWt003" _tab "%11.4f" _tab `""Replicate Weight #3""' _n ///
"_column(73)"  _tab "double  RepWt004" _tab "%11.4f" _tab `""Replicate Weight #4""' _n ///
"_column(84)"  _tab "double  RepWt005" _tab "%11.4f" _tab `""Replicate Weight #5""' _n ///
"_column(95)"  _tab "double  RepWt006" _tab "%11.4f" _tab `""Replicate Weight #6""' _n ///
"_column(106)" _tab "double  RepWt007" _tab "%11.4f" _tab `""Replicate Weight #7""' _n ///
"_column(117)" _tab "double  RepWt008" _tab "%11.4f" _tab `""Replicate Weight #8""' _n ///
"_column(128)" _tab "double  RepWt009" _tab "%11.4f" _tab `""Replicate Weight #9""' _n ///
"_column(139)" _tab "double  RepWt010" _tab "%11.4f" _tab `""Replicate Weight #10""' _n ///
"_column(150)" _tab "double  RepWt011" _tab "%11.4f" _tab `""Replicate Weight #11""' _n ///
"_column(161)" _tab "double  RepWt012" _tab "%11.4f" _tab `""Replicate Weight #12""' _n ///
"_column(172)" _tab "double  RepWt013" _tab "%11.4f" _tab `""Replicate Weight #13""' _n ///
"_column(183)" _tab "double  RepWt014" _tab "%11.4f" _tab `""Replicate Weight #14""' _n ///
"_column(194)" _tab "double  RepWt015" _tab "%11.4f" _tab `""Replicate Weight #15""' _n ///
"_column(205)" _tab "double  RepWt016" _tab "%11.4f" _tab `""Replicate Weight #16""' _n ///
"_column(216)" _tab "double  RepWt017" _tab "%11.4f" _tab `""Replicate Weight #17""' _n ///
"_column(227)" _tab "double  RepWt018" _tab "%11.4f" _tab `""Replicate Weight #18""' _n ///
"_column(238)" _tab "double  RepWt019" _tab "%11.4f" _tab `""Replicate Weight #19""' _n ///
"_column(249)" _tab "double  RepWt020" _tab "%11.4f" _tab `""Replicate Weight #20""' _n ///
"_column(260)" _tab "double  RepWt021" _tab "%11.4f" _tab `""Replicate Weight #21""' _n ///
"_column(271)" _tab "double  RepWt022" _tab "%11.4f" _tab `""Replicate Weight #22""' _n ///
"_column(282)" _tab "double  RepWt023" _tab "%11.4f" _tab `""Replicate Weight #23""' _n ///
"_column(293)" _tab "double  RepWt024" _tab "%11.4f" _tab `""Replicate Weight #24""' _n ///
"_column(304)" _tab "double  RepWt025" _tab "%11.4f" _tab `""Replicate Weight #25""' _n ///
"_column(315)" _tab "double  RepWt026" _tab "%11.4f" _tab `""Replicate Weight #26""' _n ///
"_column(326)" _tab "double  RepWt027" _tab "%11.4f" _tab `""Replicate Weight #27""' _n ///
"_column(337)" _tab "double  RepWt028" _tab "%11.4f" _tab `""Replicate Weight #28""' _n ///
"_column(348)" _tab "double  RepWt029" _tab "%11.4f" _tab `""Replicate Weight #29""' _n ///
"_column(359)" _tab "double  RepWt030" _tab "%11.4f" _tab `""Replicate Weight #30""' _n ///
"_column(370)" _tab "double  RepWt031" _tab "%11.4f" _tab `""Replicate Weight #31""' _n ///
"_column(381)" _tab "double  RepWt032" _tab "%11.4f" _tab `""Replicate Weight #32""' _n ///
"_column(392)" _tab "double  RepWt033" _tab "%11.4f" _tab `""Replicate Weight #33""' _n ///
"_column(403)" _tab "double  RepWt034" _tab "%11.4f" _tab `""Replicate Weight #34""' _n ///
"_column(414)" _tab "double  RepWt035" _tab "%11.4f" _tab `""Replicate Weight #35""' _n ///
"_column(425)" _tab "double  RepWt036" _tab "%11.4f" _tab `""Replicate Weight #36""' _n ///
"_column(436)" _tab "double  RepWt037" _tab "%11.4f" _tab `""Replicate Weight #37""' _n ///
"_column(447)" _tab "double  RepWt038" _tab "%11.4f" _tab `""Replicate Weight #38""' _n ///
"_column(458)" _tab "double  RepWt039" _tab "%11.4f" _tab `""Replicate Weight #39""' _n ///
"_column(469)" _tab "double  RepWt040" _tab "%11.4f" _tab `""Replicate Weight #40""' _n ///
"_column(480)" _tab "double  RepWt041" _tab "%11.4f" _tab `""Replicate Weight #41""' _n ///
"_column(491)" _tab "double  RepWt042" _tab "%11.4f" _tab `""Replicate Weight #42""' _n ///
"_column(502)" _tab "double  RepWt043" _tab "%11.4f" _tab `""Replicate Weight #43""' _n ///
"_column(513)" _tab "double  RepWt044" _tab "%11.4f" _tab `""Replicate Weight #44""' _n ///
"_column(524)" _tab "double  RepWt045" _tab "%11.4f" _tab `""Replicate Weight #45""' _n ///
"_column(535)" _tab "double  RepWt046" _tab "%11.4f" _tab `""Replicate Weight #46""' _n ///
"_column(546)" _tab "double  RepWt047" _tab "%11.4f" _tab `""Replicate Weight #47""' _n ///
"_column(557)" _tab "double  RepWt048" _tab "%11.4f" _tab `""Replicate Weight #48""' _n ///
"_column(568)" _tab "double  RepWt049" _tab "%11.4f" _tab `""Replicate Weight #49""' _n ///
"_column(579)" _tab "double  RepWt050" _tab "%11.4f" _tab `""Replicate Weight #50""' _n ///
"_column(590)" _tab "double  RepWt051" _tab "%11.4f" _tab `""Replicate Weight #51""' _n ///
"_column(601)" _tab "double  RepWt052" _tab "%11.4f" _tab `""Replicate Weight #52""' _n ///
"_column(612)" _tab "double  RepWt053" _tab "%11.4f" _tab `""Replicate Weight #53""' _n ///
"_column(623)" _tab "double  RepWt054" _tab "%11.4f" _tab `""Replicate Weight #54""' _n ///
"_column(634)" _tab "double  RepWt055" _tab "%11.4f" _tab `""Replicate Weight #55""' _n ///
"_column(645)" _tab "double  RepWt056" _tab "%11.4f" _tab `""Replicate Weight #56""' _n ///
"_column(656)" _tab "double  RepWt057" _tab "%11.4f" _tab `""Replicate Weight #57""' _n ///
"_column(667)" _tab "double  RepWt058" _tab "%11.4f" _tab `""Replicate Weight #58""' _n ///
"_column(678)" _tab "double  RepWt059" _tab "%11.4f" _tab `""Replicate Weight #59""' _n ///
"_column(689)" _tab "double  RepWt060" _tab "%11.4f" _tab `""Replicate Weight #60""' _n ///
"_column(700)" _tab "double  RepWt061" _tab "%11.4f" _tab `""Replicate Weight #61""' _n ///
"_column(711)" _tab "double  RepWt062" _tab "%11.4f" _tab `""Replicate Weight #62""' _n ///
"_column(722)" _tab "double  RepWt063" _tab "%11.4f" _tab `""Replicate Weight #63""' _n ///
"_column(733)" _tab "double  RepWt064" _tab "%11.4f" _tab `""Replicate Weight #64""' _n ///
"_column(744)" _tab "double  RepWt065" _tab "%11.4f" _tab `""Replicate Weight #65""' _n ///
"_column(755)" _tab "double  RepWt066" _tab "%11.4f" _tab `""Replicate Weight #66""' _n ///
"_column(766)" _tab "double  RepWt067" _tab "%11.4f" _tab `""Replicate Weight #67""' _n ///
"_column(777)" _tab "double  RepWt068" _tab "%11.4f" _tab `""Replicate Weight #68""' _n ///
"_column(788)" _tab "double  RepWt069" _tab "%11.4f" _tab `""Replicate Weight #69""' _n ///
"_column(799)" _tab "double  RepWt070" _tab "%11.4f" _tab `""Replicate Weight #70""' _n ///
"_column(810)" _tab "double  RepWt071" _tab "%11.4f" _tab `""Replicate Weight #71""' _n ///
"_column(821)" _tab "double  RepWt072" _tab "%11.4f" _tab `""Replicate Weight #72""' _n ///
"_column(832)" _tab "double  RepWt073" _tab "%11.4f" _tab `""Replicate Weight #73""' _n ///
"_column(843)" _tab "double  RepWt074" _tab "%11.4f" _tab `""Replicate Weight #74""' _n ///
"_column(854)" _tab "double  RepWt075" _tab "%11.4f" _tab `""Replicate Weight #75""' _n ///
"_column(865)" _tab "double  RepWt076" _tab "%11.4f" _tab `""Replicate Weight #76""' _n ///
"_column(876)" _tab "double  RepWt077" _tab "%11.4f" _tab `""Replicate Weight #77""' _n ///
"_column(887)" _tab "double  RepWt078" _tab "%11.4f" _tab `""Replicate Weight #78""' _n ///
"_column(898)" _tab "double  RepWt079" _tab "%11.4f" _tab `""Replicate Weight #79""' _n ///
"_column(909)" _tab "double  RepWt080" _tab "%11.4f" _tab `""Replicate Weight #80""' _n ///
"}"
set more on
file close dictionary 

//*****************************************************************************************
// Read 1995 to 2003 replicate weights

quietly infile using dictionary.dct, using ("./harmonzd.tus_cps.1992.through.2019.replicate.wgts.95_03.dat") clear

describe
                                                   
save harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta, replace

erase "dictionary.dct"
